import java.util.concurrent.Phaser;

class PhaserAsCountDownLatch {
	static void waitAndLiftOff(Phaser phaser) {
		System.out.println("Raketen-Thread wartet auf Phaser");
		phaser.awaitAdvance(0);
		System.out.println("\n\nRakete startet:");
		for (int i = 1; i <= 16; i++) {
			System.out.print(".");
			for (int j = 0; j < i/2; j++) System.out.print(" ");
			try { Thread.sleep(300);
			}  catch(InterruptedException ie) {Thread.currentThread().interrupt();}
		}
	}

	public static void main(String[] args) throws InterruptedException {
		int cdn = 10;
		var phaser = new Phaser(cdn);
		new Thread(() -> waitAndLiftOff(phaser)).start();
		Thread.sleep(300);
		System.out.println("\nCountdown läuft:");
		for (int i = cdn; i > 0; i--) {
			System.out.print(i + " ");
			phaser.arrive();
			Thread.sleep(500);
		}
	}
}
